<?php
// @codingStandardsIgnoreStart
/**
 * Template Name: Tour List
 */
get_header();

/*DESTINATION*/
$dest_args = array(
	'post_type'           => 'ht_dest',
	'post_status'         => 'publish',
	'ignore_sticky_posts' => 1,
	'posts_per_page'      => -1,
);
$dest = new WP_Query( $dest_args );

/*TOUR CATEGORY*/
$cat = get_terms( 'ht_tour_cat' );

$symbol_post       =  function_exists( 'fw_get_db_ext_settings_option' ) ? fw_get_db_ext_settings_option( 'tour', 'symbol-pos' )  : 'left';

if( is_wp_error( $dest ) || is_wp_error( $cat ) ) return get_footer();

/*UNIT PRICE*/
$unit = function_exists( 'fw_get_db_ext_settings_option' ) ? goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) ) : '&#36;';

/*ARGS*/
$args = array(
	'post_type'           => 'ht_tour',
	'post_status'         => 'publish',
	'ignore_sticky_posts' => 1,
	'posts_per_page'      => -1,
	'orderby'             => 'meta_value_num',
	'order'               => 'ASC',
);


/*GET DURATION DAYS*/
$args['meta_key'] = 'days';
$args['meta_query'] = array(
	array(
		'key'     => 'days',
		'value'   => 0,
		'compare' => '>=',
	),
);

$get_days = new WP_Query( $args );

$days_min = $days_max = 0;
$days_min_txt = $days_max_txt = '';
if( $get_days->have_posts() ){
	// $days_min =  get_post_meta( $get_days->posts[0]->ID, 'days', true );
	$days_max =  get_post_meta( $get_days->posts[$get_days->post_count - 1]->ID, 'days', true );
	$days_min_txt = 1 == intval( $days_min ) ? esc_html__( 'day', 'goto' ) : esc_html__( 'days', 'goto' );
	$days_max_txt = 1 == intval( $days_max ) ? esc_html__( 'day', 'goto' ) : esc_html__( 'days', 'goto' );
}

/*GET PRICE*/
unset( $args['meta_key'] );
unset( $args['meta_query'] );
$args['meta_key'] = 'price';
$args['meta_query'] = array(
	array(
		'key'     => 'price',
		'value'   => 0,
		'compare' => '>=',
	),
);

$get_price = new WP_Query( $args );

$price_min = $price_max = 0;
if ( $get_price->have_posts() ) {
	// $price_min =  get_post_meta( $get_price->posts[0]->ID, 'price', true );
	$price_max =  get_post_meta( $get_price->posts[ $get_price->post_count - 1 ]->ID, 'price', true );
}

/*RANGE SLIDER*/
wp_enqueue_script( 'omni-slider-js' );

/*ADD POLYFILL FOR IE*/
if( goto_ie() ){
	wp_enqueue_script( 'polyfill-ie-js' );
}

/*MAIN SCRIPT FOR TOUR LIST*/
wp_enqueue_script( 'goto-tour-list' );

/*GET QUERY VIA METHOD GET*/
$order        = 'DESC';
$keywords     = ! empty( $_GET['keywords'] ) ? sanitize_text_field( wp_unslash( $_GET['keywords'] ) ) : '';
$orderby      = ! empty( $_GET['orderby'] ) ? sanitize_text_field( wp_unslash(  $_GET['orderby'] ) ) : 'date';
$view_type    = ! empty( $_GET['view_type'] ) ? sanitize_text_field( wp_unslash(  $_GET['view_type'] ) ) : 'list';
$start_date   = ! empty( $_GET['start_date'] ) ? sanitize_text_field( wp_unslash(  $_GET['start_date'] ) ) : '';
$dest_id      = ! empty( $_GET['destination'] ) ? sanitize_text_field( wp_unslash(  $_GET['destination'] ) ) : '';
$rating_star  = ! empty( $_GET['rating'] ) ? sanitize_text_field( wp_unslash(  $_GET['rating'] ) ) : '';
$cat_id       = ! empty( $_GET['category'] ) ? sanitize_text_field( wp_unslash(  $_GET['category'] ) ) : '';
$min_days     = isset( $_GET['min_days'] ) && '' !== $_GET['min_days'] ? sanitize_text_field( wp_unslash( $_GET['min_days'] ) ) : $days_min;
$max_days     = isset( $_GET['max_days'] ) && '' !== $_GET['max_days'] ? sanitize_text_field( wp_unslash( $_GET['max_days'] ) ) : $days_max;
$min_price    = isset( $_GET['min_price'] ) && '' !== $_GET['min_price'] ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : $price_min;
$max_price    = isset( $_GET['max_price'] ) && '' !== $_GET['max_price'] ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : $price_max;

$date         = ! empty( $_GET['date'] ) ? sanitize_text_field( wp_unslash( $_GET['date'] ) ) : 0;
$availability = ! empty( $_GET['avaibility'] ) ? absint( $_GET['avaibility'] ) : 0;

/*DURATION DAYS*/
$days_arr = array(
	'key'     => 'days',
	'value'   => array( $min_days, $max_days ),
	'compare' => 'BETWEEN',
	'type'    => 'NUMERIC'
);

/*AVAIBILITY*/
$guest = array(
	'key'     => 'avaibility',
	'value'   => $availability,
	'compare' => '>=',
	'type'    => 'NUMERIC'
);

/*START DATE*/
$date_meta = date( 'Ymd', strtotime( $start_date ) );
$date_arr = array(
	'key'     => 'start_date',
	'value'   => $date_meta,
	'compare' => '>=',
	'type'    => 'DATE'
);

/*TOUR QUERY*/
$per_page = get_option( 'posts_per_page', 10 );

$tours = array(
	'post_type'      => 'ht_tour',
	'post_status'    => 'publish',
	'posts_per_page' => $per_page,
	'orderby'        => $orderby,
	'order'          => $order,
	'paged'          => 1,
);

// Get date query tour by url param.
if ( '' !== $min_days ) {
	$tours['meta_query'][] = $days_arr;
}

/*GET POST BY DATE FIELD*/
if( ! empty( $start_date ) ){
	unset( $tours['meta_query'] );
	$tours['meta_query'] = array( $days_arr, $date_arr );
}

/*TAX WITH CATEGORY ID*/
$cat_tax = array(
	'taxonomy' => 'ht_tour_cat',
	'field'    => 'term_id',
	'terms'    => $cat_id,
);

/*GET POST BY TOUR CATEGORY*/
if( ! empty( $cat_id ) ){
	$tours['tax_query'] = array( $cat_tax );
}

/*GET POST BY DESTINATION*/
if( ! empty( $dest_id ) ){
	$pids = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $dest_id, 'tour_id' ) : array();
	if( ! empty( $pids ) ){
		$tours['post__in'] = $pids;
	}
}

// Filter by rating average.
if ( '' != $rating_star && 'all' != $rating_star ) {
	$tours['meta_query'] = array(
		array(
			'key'     => 'rating',
			'value'   => $rating_star,
			'compare' => '>=',
			'type'    => 'NUMERIC'
		),
	);
}

/*GET POST BY KEYWORDS*/
if( ! empty( $keywords ) ){
	global $wpdb;
	$kw = strtoupper( $keywords );

	$kw = str_replace( '"', '', $kw );
	$kw = str_replace( "'", '', $kw );

	/*GET TOUR ID WITH SEARCH LIKE TOUR TITLE */
	$tour_ids = $wpdb->get_col( "SELECT ID FROM $wpdb->posts WHERE UCASE( post_title ) LIKE '%$kw%' AND post_type='ht_tour' AND post_status='publish'" );

	/*GET DEST ID WITH SEARCH LIKE DEST TITLE */
	$get_dest_ids = $wpdb->get_col( "SELECT ID FROM $wpdb->posts WHERE UCASE( post_title ) LIKE '%$kw%' AND post_type='ht_dest' AND post_status='publish'" );

	/*GET POST ID RELATED WITH DEST ID*/
	$tour_ids_related_with_dest = array();
	if( ! empty( $get_dest_ids ) ){
		foreach( $get_dest_ids as $k ){
			$tour_ids_related_with_dest[] = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $k, 'tour_id' ) : array();
		}
		$tour_ids_related_with_dest = call_user_func_array( 'array_merge_recursive', $tour_ids_related_with_dest );   
	}

	/*MERGE TOUR ID ARRAY*/
	$pids = array_unique( array_merge( $tour_ids, $tour_ids_related_with_dest ) );

	if( ! empty( $pids ) ){
		$tours['post__in'] = $pids;
	}else{
		unset( $tours['post_type'] );
		$tours['post_type'] = 'skt_t1_faker';
	}
}

// Price slider && Re-orderby price.
if ( $min_price >= 0 || $max_price >= 0 || in_array( $orderby, [ 'price-high-to-low', 'price-low-to-high' ] ) ) {
	$attr = [
		'min_price' => $min_price,
		'max_price' => $max_price,
		'orderby'   => $orderby,
	];
	$ids       = goto_get_tour_list( $tours, $attr );
	$post_type = ( empty( $ids ) || 'skt_t1_faker' == $tours['post_type'] ) ? 'skt_t1_faker' : 'ht_tour';
	$tours     = [
		'post_type'      => $post_type,
		'posts_per_page' => $per_page,
		'post_status'    => 'publish',
		'paged'          => 1,
		'post__in'       => $ids,
		'orderby'        => 'post__in',
	];
}

$query = new WP_Query( $tours );

/*GET RESULT COUNT*/
$tours['fields']         = 'ids';
$tours['posts_per_page'] = -1;
$get_total               = get_posts( $tours );

// Rating average.
$rating       = goto_tour_rating_average( $get_total );
$rating_count = array_count_values( $rating );
$rating_count = goto_count_tour_rating_average( $rating_count );

/*LOCALIZE SCRIPT*/
$params = array(
	'tour_nonce'        => wp_create_nonce( 'tour_list_nonce' ),
	'min_days'          => $days_min,
	'max_days'          => $days_max,
	'min_days_txt'      => $days_min_txt,
	'max_days_txt'      => $days_max_txt,
	'days_start'        => $min_days,
	'days_end'          => $max_days,
	'min_price'         => $price_min,
	'max_price'         => $price_max,
	'price_start'       => $min_price,
	'price_end'         => $max_price,
	'key_start_date'    => esc_html__( 'Start date: ', 'goto' ),
	'key_dest'          => esc_html__( 'Destinations: ', 'goto' ),
	'key_cat'           => esc_html__( 'Category: ', 'goto' ),
	'key_rating'        => esc_html__( 'Rating: ', 'goto' ),
	'key_price'         => esc_html__( 'Price: ', 'goto' ),
	'key_duration_date' => esc_html__( 'Date duration: ', 'goto' ),
	'orderby'           => esc_html__( 'Sort by: ', 'goto' ),
	'view_type'         => esc_html__( 'View type: ', 'goto' ),
	'keywords'          => esc_html__( 'Keywords: ', 'goto' ),
	'avaibility'        => esc_html__( 'Availability: ', 'goto' ),
	'unit'              => $unit,
	'clear'             => esc_html__( 'Clear All', 'goto' ),
);
wp_localize_script( 'goto-tour-list', 'goto_ajax_data', $params );

/*DATE PICKER*/
goto_date_picker( '#tour-list-date-field' );

/* Sorry, the content area was not found in your page.
You must call the_content function in the current template, in order for Elementor to work on this page. -- Elementor said.
***************************************************/
//the_content();

?>

	<div class="main-tour-list">
		<div class="container">
			<?php /* LEFT SIDEBAR FILTER
			***************************************************/ ?>
			<div class="tour-list-sidebar">
				<span class="tl-sidebar-title"><?php esc_html_e( 'Your Filter:', 'goto' ); ?></span>
				<form id="tl-filter-form" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php /*SEARCH FIELD*/ ?>
					<div id="filter-by-keyword" class="tl-sidebar-block">
						<h4 class="tl-block-title"><?php esc_html_e( 'Keywords', 'goto' ); ?></h4>
						<input id="tour-list-keyword-field" type="text" placeholder="<?php esc_attr_e( 'Enter your Keywords...', 'goto' ); ?>" name="keywords" value="<?php echo esc_attr( $keywords ); ?>">
					</div>
					
					<?php /*START DATE*/ ?>
					<div id="filter-by-date" class="tl-sidebar-block">
						<h4 class="tl-block-title"><?php esc_html_e( 'Departure Date', 'goto' ); ?></h4>
						<input id="tour-list-date-field" type="text" placeholder="<?php esc_attr_e( 'Select special date', 'goto' ); ?>" name="date" value="<?php echo esc_attr( $start_date ); ?>">
					</div>
					
					<?php /*CATEGORY****************************************************/ ?>
					<?php if( ! empty( $cat ) ): ?>
						<div id="filter-by-category" class="tl-sidebar-block">
							<h4 class="tl-block-title"><?php esc_html_e( 'Tour Category', 'goto' ); ?></h4>
							<?php foreach( $cat as $k => $c ): ?>
								<span class="tl-term-list tl-radio-input">
									<input type="radio" data-id="<?php echo esc_attr( $c->term_id ); ?>" id="cat-id-<?php echo esc_attr( $c->term_id ); ?>" name="tour-list-cat" data-name="<?php echo esc_attr( $c->name ); ?>" <?php echo ( $cat_id == $c->term_id ) ? 'checked' : ''; ?>>
									<label for="cat-id-<?php echo esc_attr( $c->term_id ); ?>"><span></span><?php echo esc_html( $c->name ); ?></label>
									<span>(<?php echo esc_html( $c->count ); ?>)</span>
								</span>

								<?php /*EXPAND BUTTON*/ ?>
								<?php if( count( $cat ) > 3 && 3 == $k ): ?>
									<span class="filter-expand"><?php esc_html_e( 'More', 'goto' ); ?></span>
								<?php endif; ?>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>

					<?php /*DESTINATIONS****************************************************/ ?>
					<?php if( $dest->have_posts() ): ?>
						<div id="filter-by-destinations" class="tl-sidebar-block">
							<h4 class="tl-block-title"><?php esc_html_e( 'Destinations', 'goto' ); ?></h4>
							<?php
								foreach( $dest->posts as $k => $d ):
									$dest_count = function_exists( 'fw_get_db_post_option' ) ? count( fw_get_db_post_option( $d->ID, 'tour_id' ) ) : false;
									if( $dest_count ):
								?>
									<span class="tl-term-list tl-radio-input">
										<input type="radio" data-id="<?php echo esc_attr( $d->ID ); ?>" id="dest-id-<?php echo esc_attr( $d->ID ); ?>" name="tour-list-dest" data-name="<?php echo esc_attr( $d->post_title ); ?>" <?php echo ( $dest_id == $d->ID ) ? 'checked' : ''; ?> >
										<label for="dest-id-<?php echo esc_attr( $d->ID ); ?>"><span></span><?php echo esc_html( $d->post_title ); ?></label>
										<span>(<?php echo esc_html( $dest_count ); ?>)</span>
									</span>

									<?php /*EXPAND BUTTON*/ ?>
									<?php if( count( $dest->posts ) > 3 && 3 == $k ): ?>
										<span class="filter-expand"><?php esc_html_e( 'More', 'goto' ); ?></span>
									<?php endif; ?>
								<?php endif; ?>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
					
					<?php /*DAYS****************************************************/ ?>
					<?php if( '' !== $min_days ) : ?>
						<div id="filter-by-duration" class="tl-sidebar-block">
							<h4 class="tl-block-title"><?php esc_html_e( 'Duaration', 'goto' ); ?></h4>
							<div id="tl-days-slider"></div>
							<span class="tl-spn-left">
								<span id="tl-days-min"></span><span class="tl-days-of-week" id="single-day"><?php echo esc_html( $days_min_txt ); ?></span>
								<input type="hidden" value="<?php echo esc_attr( $min_days ); ?>" id="tl-days-minval" name="min_days">
							</span>
							<span class="tl-spn-right">
								<span id="tl-days-max"></span><span class="tl-days-of-week" id="plural-day"><?php echo esc_html( $days_max_txt ); ?></span>
								<input type="hidden" value="<?php echo esc_attr( $max_days ); ?>" id="tl-days-maxval" name="max_days">
							</span>
						</div>
					<?php endif; ?>

					<?php /*PRICE****************************************************/ ?>
					<?php if( '' !== $min_price ) : ?>
						<div id="filter-by-price" class="tl-sidebar-block">
							<h4 class="tl-block-title"><?php esc_html_e( 'Our Buget', 'goto' ); ?></h4>
							<div id="tl-price-slider"></div>
							<span class="tl-spn-left">
								<?php if($symbol_post == 'left') : ?>
									<?php echo esc_attr( $unit ); ?><span id="tl-price-min"></span>
								<?php else : ?>
									<span id="tl-price-min"></span><?php echo esc_attr( $unit ); ?>
								<?php endif; ?>

								<input type="hidden" value="<?php echo esc_attr( $min_price ); ?>" id="tl-price-minval" name="min_price">
							</span>
							<span class="tl-spn-right">
								<?php if($symbol_post == 'left') : ?>
									<?php echo esc_attr( $unit ); ?><span id="tl-price-max"></span>
								<?php else : ?>
									<span id="tl-price-max"></span><?php echo esc_attr( $unit ); ?>
								<?php endif; ?>
								<input type="hidden" value="<?php echo esc_attr( $max_price ); ?>" id="tl-price-maxval" name="max_price">
							</span>
						</div>
					<?php endif; ?>

					<?php /*RATING****************************************************/ ?>
					<?php if ( function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ) { ?>
						<div id="filter-by-rating" class="tl-sidebar-block">
							<h4 class="tl-block-title"><?php esc_html_e( 'Rating', 'goto' ); ?></h4>
							<span class="tl-rating-list tl-radio-input">
								<input type="radio" name="tour-list-rating" id="tl-tour-rating-all" data-name="<?php esc_attr_e( 'Show all', 'goto' ); ?>" data-id="all" <?php echo ( 'all' == $rating_star ) ? 'checked' : ''; ?>>
								<label for="tl-tour-rating-all">
									<span></span>
									<?php esc_html_e( 'Show all', 'goto' ); ?>
								</label>
								<span><?php echo count( $get_total ); ?></span>
							</span>
							<span class="tl-rating-list tl-radio-input">
								<input type="radio" name="tour-list-rating" id="tl-tour-rating-1" data-id="1" data-name="<?php esc_attr_e( '1 stars and higher', 'goto' ); ?>" <?php echo ( '1' == $rating_star ) ? 'checked' : ''; ?>>
								<label for="tl-tour-rating-1">
									<span></span>
									<?php esc_html_e( '1 star and higher', 'goto' ); ?>
								</label>
								<span><?php echo esc_html( $rating_count[0] ); ?></span>
							</span>
							<span class="tl-rating-list tl-radio-input">
								<input type="radio" name="tour-list-rating" id="tl-tour-rating-2" data-id="2" data-name="<?php esc_attr_e( '2 stars and higher', 'goto' ); ?>" <?php echo ( '2' == $rating_star ) ? 'checked' : ''; ?>>
								<label for="tl-tour-rating-2">
									<span></span>
									<?php esc_html_e( '2 stars and higher', 'goto' ); ?>
								</label>
								<span><?php echo esc_html( $rating_count[1] ); ?></span>
							</span>
							<span class="tl-rating-list tl-radio-input">
								<input type="radio" name="tour-list-rating" id="tl-tour-rating-3" data-id="3" data-name="<?php esc_attr_e( '3 stars and higher', 'goto' ); ?>" <?php echo ( '3' == $rating_star ) ? 'checked' : ''; ?>>
								<label for="tl-tour-rating-3">
									<span></span>
									<?php esc_html_e( '3 stars and higher', 'goto' ); ?>
								</label>
								<span><?php echo esc_html( $rating_count[2] ); ?></span>
							</span>
							<span class="tl-rating-list tl-radio-input">
								<input type="radio" name="tour-list-rating" id="tl-tour-rating-4" data-id="4" data-name="<?php esc_attr_e( '4 stars and higher', 'goto' ); ?>" <?php echo ( '4' == $rating_star ) ? 'checked' : ''; ?>>
								<label for="tl-tour-rating-4">
									<span></span>
									<?php esc_html_e( '4 stars and higher', 'goto' ); ?>
								</label>
								<span><?php echo esc_html( $rating_count[3] ); ?></span>
							</span>
						</div>
					<?php } ?>

					<?php /*ACTION INPUT && DATA INPUT*/ ?>
					<input type="hidden" value="<?php echo abs( $availability ); ?>" name="avaibility" id="tl-avaibility-val">
					<input type="hidden" value="newest-to-oldest" name="short_by" id="tl-short-by-val">
					<input type="hidden" value="<?php echo esc_attr( $view_type ); ?>" name="view_type" id="tl-view-type-val">
					<input type="hidden" value="1" name="paged" id="tl-paged-val">
					<input type="reset" name="reset" id="tl-form-reset">
					<input type="submit" id="tl-form-submit">
				</form>
			</div>
			
			<?php /* RIGHT MAIN CONTENT
			***************************************************/ ?>
			<main id="tour-list-content" class="tour-view-<?php echo esc_attr( $view_type ); ?>">
				<div id="tl-topbar">
					<div class="tl-topbar-sortby">
						<span><?php esc_html_e( 'Sort by:', 'goto' ); ?></span>
						<select id="tl-dropdown-sortby">
							<option value="newest-to-oldest" <?php echo ( 'newest-to-oldest' == $orderby ) ? 'selected': ''; ?>><?php esc_html_e( 'Newest first', 'goto' ); ?></option>
							<option value="tour-name-ascending" <?php echo ( 'tour-name-ascending' == $orderby ) ? 'selected': ''; ?>><?php esc_html_e( 'Name: A - Z', 'goto' ); ?></option>
							<option value="tour-name-descending" <?php echo ( 'tour-name-descending' == $orderby ) ? 'selected': ''; ?>><?php esc_html_e( 'Name: Z - A', 'goto' ); ?></option>
							<option value="price-high-to-low" <?php echo ( 'price-high-to-low' == $orderby ) ? 'selected': ''; ?>><?php esc_html_e( 'Price: high - low', 'goto' ); ?></option>
							<option value="price-low-to-high" <?php echo ( 'price-low-to-high' == $orderby ) ? 'selected': ''; ?>><?php esc_html_e( 'Price: low - high', 'goto' ); ?></option>
						</select>
					</div>
					<span class="tl-view-as">
						<span><?php esc_html_e( 'View as:', 'goto' ); ?></span>
						<span class="tl-view-btn goto-icon-list <?php echo ( 'list' == $view_type ) ? 'active' : ''; ?>" data-view="list"></span>
						<span class="tl-view-btn goto-icon-grid <?php echo ( 'grid' == $view_type ) ? 'active' : ''; ?>" data-view="grid"></span>
					</span>
					<span id="tl-results-count"><?php echo goto_result_count( $get_total, $per_page, $paged = 1 ); ?></span>
				</div>
				<div id="tl-filter-key"></div>
				<div id="tl-list">
					<?php
						if( $query->have_posts() ):
							goto_tour_list_query( $query, $view_type, $paged = 1 );
						else:
							echo '<p class="no-post-founds">'. esc_html__( 'Sorry, nothing found', 'goto' ) .'</p>';
						endif;
					?>
				</div>
			</main>
		</div>
	</div>

<?php
	get_footer();
